#include "stm32f10x.h"
#include "delay.h"
#include "sys.h"
#include "2in9_epd.h"
#include "Ap_29demo.h"	
#include "fonts.h"
#include "usart.h"	
#include "epd_gui.h"

/****************************
* PB12-----SPI2_NSS
* PB13-----SPI2_SCK
* PB15-----SPI2_MOSI
* PA8------DC
* PA11-----RST
* PA12-----BUSY
***************************/
/******************************
 * image :
 * 0------------> x (1~168) 
 * |
 * |
 * |
 * |
 * y (1~384)
 * 
 * */

unsigned char image[16128];//Define canvas space  

//Tips//
/*
1.When the e-paper is refreshed in full screen, the picture flicker is a normal phenomenon, and the main function is to clear the display afterimage in the previous picture.
2.When the partial refresh is performed, the screen does not flash.
3.After the e-paper is refreshed, you need to put it into sleep mode, please do not delete the sleep command.
4.Please do not take out the electronic paper when power is on.
5.Wake up from sleep, need to re-initialize the e-paper.
6.When you need to transplant the driver, you only need to change the corresponding IO. The BUSY pin is the input mode and the others are the output mode.
*/
int	main(void)
{
	  int i;
		Uart1Init(115200,0,0);
		printf("\r\n-- 4.2inch epaper demo --\r\n");
		printf("STM32F103C8T6\r\n");
		delay_init();	    	     //Delay function initialization
		NVIC_Configuration(); 	//Set NVIC interrupt grouping 2
		EPD_GPIO_Init();       //EPD GPIO  initialization
		while(1)
		{
				/************Fast picture display(1.5s)*******************/
				EPD_HW_Init();
				PIC_display(gImage_1); 
				EPD_DeepSleep();  
				delay_xms(2000);
				delay_xms(2000);
			
//			 EPD_HW_Init();
//			 EPD_WhiteScreen_Red();
//			 EPD_DeepSleep();        //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
//			 delay_xms(1000);

//			 EPD_HW_Init();
//			 EPD_WhiteScreen_Yellow();
//			 EPD_DeepSleep();        //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
//			 delay_xms(1000);
         
			  EPD_HW_Init(); 
			  Image_Init(image, EPD_WIDTH, EPD_HEIGHT, 270, EPD_2IN9G_WHITE);
//			  /**************Drawing**********************/
				Gui_Clear(EPD_2IN9G_WHITE);
				//Point   
				Gui_Draw_Point(3, 1, EPD_2IN9G_BLACK, PIXEL_1X1, DOT_STYLE_DFT);
				Gui_Draw_Point(3, 15, EPD_2IN9G_YELLOW, PIXEL_2X2, DOT_STYLE_DFT);
				Gui_Draw_Point(5, 40, EPD_2IN9G_RED, PIXEL_3X3, DOT_STYLE_DFT);
				Gui_Draw_Point(5, 55, EPD_2IN9G_BLACK, PIXEL_4X4, DOT_STYLE_DFT);
				//Line
				Gui_Draw_Line(15, 5, 55, 110, EPD_2IN9G_BLACK, PIXEL_1X1, SOLID);
				Gui_Draw_Line(15, 50, 55, 10, EPD_2IN9G_BLACK, PIXEL_1X1, SOLID);
				//Rectangle
				Gui_Draw_Rectangle(15, 5, 55, 45, EPD_2IN9G_BLACK, EMPTY, PIXEL_1X1);
				Gui_Draw_Rectangle(90, 5, 130, 45, EPD_2IN9G_BLACK, FULL, PIXEL_1X1);
				//Circle
				Gui_Draw_Circle(170, 25, 18, EPD_2IN9G_YELLOW, EMPTY, PIXEL_1X1);
				Gui_Draw_Circle(226, 25, 18, EPD_2IN9G_RED, FULL, PIXEL_1X1);
				Gui_Draw_Str(60, 50, "168x384", &Font16, EPD_2IN9G_WHITE, EPD_2IN9G_YELLOW); //7*12
				Gui_Draw_Str(145, 50, "SPI interface", &Font16, EPD_2IN9G_WHITE, EPD_2IN9G_RED); //11*16
				Gui_Draw_Str(80, 75, "2.9\" E-Paper", &Font20, EPD_2IN9G_WHITE, EPD_2IN9G_YELLOW); //14*20
				Gui_Draw_Str(80, 100, "SEENGREAT", &Font24, EPD_2IN9G_WHITE, EPD_2IN9G_RED); //17*24


			  GUI_display(image);
			  EPD_DeepSleep();//EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
			  delay_xms(2000); //2s
			  delay_xms(2000); //2s
			
			  EPD_HW_Init(); //Full screen refresh initialization.
			  EPD_WhiteScreen_White(); //Clear screen function.
			  EPD_DeepSleep(); //Enter the sleep mode and please do not delete it, otherwise it will reduce the lifespan of the screen.
			  delay_xms(2000); //2s
			  while(1);		
	  }
}	


